-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema pruebas
--

-- CREATE DATABASE IF NOT EXISTS pruebas;
-- USE pruebas;

--
-- Definition of table `scheduler_queue`
--

DROP TABLE IF EXISTS `scheduler_queue`;
CREATE TABLE `scheduler_queue` (
  `id_queue` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL,
  `comment` varchar(300) DEFAULT NULL,
  `last_control_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id_queue`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `scheduler_queue`
--

/*!40000 ALTER TABLE `scheduler_queue` DISABLE KEYS */;
INSERT INTO `scheduler_queue` (`id_queue`,`code`,`comment`,`last_control_date`) VALUES 
 (1,'Fast','Queue for processes that take very little time to complete','2024-01-25 21:02:01'),
 (2,'Heavy','Queue for processes that take a long way to complete','2024-01-25 21:03:01');
/*!40000 ALTER TABLE `scheduler_queue` ENABLE KEYS */;


--
-- Definition of table `scheduler_queue-user`
--

DROP TABLE IF EXISTS `scheduler_queue-user`;
CREATE TABLE `scheduler_queue-user` (
  `id_user` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(16) NOT NULL,
  `password` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  PRIMARY KEY (`id_user`),
  UNIQUE KEY `login_UNIQUE` (`login`),
  UNIQUE KEY `email_UNIQUE` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `scheduler_queue-user`
--

/*!40000 ALTER TABLE `scheduler_queue-user` DISABLE KEYS */;
INSERT INTO `scheduler_queue-user` (`id_user`,`login`,`password`,`name`,`email`) VALUES 
 (1,'admin','21232f297a57a5a743894a0e4a801fc3','Administrator','info@fhumanes.com'),
 (2,'user1','24c9e15e52afc47c225b757e7bee1f9d','User1','info2@fhumanes.com');
/*!40000 ALTER TABLE `scheduler_queue-user` ENABLE KEYS */;


--
-- Definition of table `scheduler_queue_noti`
--

DROP TABLE IF EXISTS `scheduler_queue_noti`;
CREATE TABLE `scheduler_queue_noti` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` mediumtext,
  `user` varchar(255) DEFAULT NULL,
  `provider` varchar(5) DEFAULT NULL,
  `title` varchar(300) DEFAULT NULL,
  `url` mediumtext,
  `icon` varchar(300) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `expire` datetime DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `group` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `scheduler_queue_noti`
--

/*!40000 ALTER TABLE `scheduler_queue_noti` DISABLE KEYS */;
INSERT INTO `scheduler_queue_noti` (`id`,`message`,`user`,`provider`,`title`,`url`,`icon`,`created`,`expire`,`type`,`group`) VALUES 
 (1,'{\"message\":\"Task Batch executed: 4\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php','fa-envelope','2024-01-24 20:15:18',NULL,0,NULL),
 (2,'{\"message\":\"Task Batch executed: 5\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php','fa-envelope','2024-01-24 20:16:19',NULL,0,NULL),
 (3,'{\"lastRead\":44}','admin','',NULL,NULL,NULL,NULL,NULL,1,NULL),
 (4,'{\"message\":\"Task Batch executed: 2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?editid1=2','fa-envelope','2024-01-24 20:21:28',NULL,0,NULL),
 (5,'{\"message\":\"Task Batch executed: 3\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?editid1=3','fa-envelope','2024-01-24 20:21:34',NULL,0,NULL),
 (6,'{\"message\":\"Task Batch executed: 2 Code: Fast\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?editid1=2','fa-envelope','2024-01-24 20:23:43',NULL,0,NULL),
 (7,'{\"message\":\"Task Batch executed: 3 Code: Fast\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?editid1=3','fa-envelope','2024-01-24 20:23:48',NULL,0,NULL),
 (8,'{\"message\":\"Task Batch executed: 2 - Code: test1\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?editid1=2','fa-envelope','2024-01-24 20:27:25',NULL,0,NULL),
 (9,'{\"message\":\"Task Batch executed: 3 - Code: test1\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?editid1=3','fa-envelope','2024-01-24 20:27:30',NULL,0,NULL),
 (10,'{\"message\":\"Task Batch executed: 4 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?editid1=4','fa-envelope','2024-01-24 20:33:43',NULL,0,NULL),
 (11,'{\"message\":\"Task Batch executed: 5 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?editid1=5','fa-envelope','2024-01-24 20:33:49',NULL,0,NULL),
 (12,'{\"message\":\"Task Batch executed: 2 - Code: test1\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=2','fa-envelope','2024-01-24 20:40:03',NULL,0,NULL),
 (13,'{\"message\":\"Task Batch executed: 3 - Code: test1\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=3','fa-envelope','2024-01-24 20:40:08',NULL,0,NULL),
 (14,'{\"message\":\"Task Batch executed: 4 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=4','fa-envelope','2024-01-24 21:11:57',NULL,0,NULL),
 (15,'{\"message\":\"Task Batch executed: 5 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=5','fa-envelope','2024-01-24 21:12:02',NULL,0,NULL),
 (16,'{\"message\":\"Task Batch executed: 4 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=4','fa-envelope','2024-01-24 21:14:10',NULL,0,NULL),
 (17,'{\"message\":\"Task Batch executed: 5 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=5','fa-envelope','2024-01-24 21:14:15',NULL,0,NULL),
 (18,'{\"message\":\"Task Batch executed: 4 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=4','fa-envelope','2024-01-24 21:19:59',NULL,0,NULL),
 (19,'{\"message\":\"Task Batch executed: 5 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=5','fa-envelope','2024-01-24 21:20:04',NULL,0,NULL),
 (20,'{\"message\":\"Task Batch executed: 4 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=4','fa-envelope','2024-01-24 21:22:23',NULL,0,NULL),
 (21,'{\"message\":\"Task Batch executed: 5 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=5','fa-envelope','2024-01-24 21:22:28',NULL,0,NULL),
 (22,'{\"message\":\"Task Batch executed: 4 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=4','fa-envelope','2024-01-24 21:36:43',NULL,0,NULL),
 (23,'{\"message\":\"Task Batch executed: 5 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=5','fa-envelope','2024-01-24 21:36:48',NULL,0,NULL),
 (24,'{\"message\":\"Task Batch executed: 4 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=4','fa-envelope','2024-01-24 21:40:20',NULL,0,NULL),
 (25,'{\"message\":\"Task Batch executed: 5 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=5','fa-envelope','2024-01-24 21:40:26',NULL,0,NULL),
 (26,'{\"message\":\"Task Batch executed: 2 - Code: test1\",\"newWindow\":true}','user1',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=2','fa-envelope','2024-01-25 19:52:38',NULL,0,NULL),
 (27,'{\"message\":\"Task Batch executed: 3 - Code: test1\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=3','fa-envelope','2024-01-25 19:52:43',NULL,0,NULL),
 (28,'{\"message\":\"Task Batch executed: 4 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=4','fa-envelope','2024-01-25 19:53:01',NULL,0,NULL),
 (29,'{\"message\":\"Task Batch executed: 5 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=5','fa-envelope','2024-01-25 19:53:06',NULL,0,NULL),
 (30,'{\"lastRead\":34}','user1','',NULL,NULL,NULL,NULL,NULL,1,NULL),
 (31,'{\"message\":\"Task Batch executed: 6 - Code: test1\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=6','fa-envelope','2024-01-25 20:54:56',NULL,0,NULL),
 (32,'{\"message\":\"Task Batch executed: 8 - Code: test1\",\"newWindow\":true}','user1',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=8','fa-envelope','2024-01-25 20:55:02',NULL,0,NULL),
 (33,'{\"message\":\"Task Batch executed: 7 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=7','fa-envelope','2024-01-25 20:55:30',NULL,0,NULL),
 (34,'{\"message\":\"Task Batch executed: 9 - Code: test2\",\"newWindow\":true}','user1',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=9','fa-envelope','2024-01-25 20:55:35',NULL,0,NULL),
 (35,'{\"message\":\"Task Batch executed: 10 - Code: test1\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=10','fa-envelope','2024-01-25 20:57:14',NULL,0,NULL),
 (36,'{\"message\":\"Task Batch executed: 11 - Code: test1\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=11','fa-envelope','2024-01-25 20:57:19',NULL,0,NULL),
 (37,'{\"message\":\"Task Batch executed: 12 - Code: test1\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=12','fa-envelope','2024-01-25 20:57:24',NULL,0,NULL),
 (38,'{\"message\":\"Task Batch executed: 13 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=13','fa-envelope','2024-01-25 20:57:44',NULL,0,NULL),
 (39,'{\"message\":\"Task Batch executed: 14 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=14','fa-envelope','2024-01-25 20:57:49',NULL,0,NULL),
 (40,'{\"message\":\"Task Batch executed: 15 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=15','fa-envelope','2024-01-25 20:57:55',NULL,0,NULL),
 (41,'{\"message\":\"Task Batch executed: 16 - Code: test1\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=16','fa-envelope','2024-01-25 21:02:07',NULL,0,NULL),
 (42,'{\"message\":\"Task Batch executed: 17 - Code: test1\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=17','fa-envelope','2024-01-25 21:02:12',NULL,0,NULL),
 (43,'{\"message\":\"Task Batch executed: 18 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=18','fa-envelope','2024-01-25 21:03:07',NULL,0,NULL),
 (44,'{\"message\":\"Task Batch executed: 19 - Code: test2\",\"newWindow\":true}','admin',NULL,'Batch Task','scheduler_queue_task_execution_view.php?page=view_special&editid1=19','fa-envelope','2024-01-25 21:03:12',NULL,0,NULL);
/*!40000 ALTER TABLE `scheduler_queue_noti` ENABLE KEYS */;


--
-- Definition of table `scheduler_queue_status`
--

DROP TABLE IF EXISTS `scheduler_queue_status`;
CREATE TABLE `scheduler_queue_status` (
  `id_status` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(40) NOT NULL,
  PRIMARY KEY (`id_status`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `scheduler_queue_status`
--

/*!40000 ALTER TABLE `scheduler_queue_status` DISABLE KEYS */;
INSERT INTO `scheduler_queue_status` (`id_status`,`title`) VALUES 
 (1,'Pending execution'),
 (2,'Initiated scheduler'),
 (3,'Initiated execution'),
 (4,'Finished execution');
/*!40000 ALTER TABLE `scheduler_queue_status` ENABLE KEYS */;


--
-- Definition of table `scheduler_queue_task`
--

DROP TABLE IF EXISTS `scheduler_queue_task`;
CREATE TABLE `scheduler_queue_task` (
  `id_task` int(11) NOT NULL AUTO_INCREMENT,
  `scheduler_queue_id` int(11) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `title` varchar(50) NOT NULL,
  `coment` varchar(300) DEFAULT NULL,
  `date_init` datetime NOT NULL,
  `date_end` datetime DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `command` varchar(300) NOT NULL,
  `user_default` varchar(16) NOT NULL,
  `group_default` varchar(25) NOT NULL,
  `max_time_minutes` int(11) NOT NULL DEFAULT '5',
  PRIMARY KEY (`id_task`),
  UNIQUE KEY `code_UNIQUE` (`code`),
  KEY `fk_scheduler_queue_task_scheduler_queue1_idx` (`scheduler_queue_id`),
  CONSTRAINT `fk_scheduler_queu_task_scheduler_queu1` FOREIGN KEY (`scheduler_queue_id`) REFERENCES `scheduler_queue` (`id_queue`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `scheduler_queue_task`
--

/*!40000 ALTER TABLE `scheduler_queue_task` DISABLE KEYS */;
INSERT INTO `scheduler_queue_task` (`id_task`,`scheduler_queue_id`,`code`,`title`,`coment`,`date_init`,`date_end`,`status`,`command`,`user_default`,`group_default`,`max_time_minutes`) VALUES 
 (1,1,'test1','Process queue management test','Process queue management test','2024-01-19 20:00:00',NULL,0,'php  {DIR}/My_Code/Jobs/test1.php --id_task={ID_TASK}','admin','administrator',2),
 (2,2,'test2','Process test','','2024-01-24 13:42:54',NULL,0,'php  {DIR}/My_Code/Jobs/test2.php --id_task={ID_TASK}','admin','',1);
/*!40000 ALTER TABLE `scheduler_queue_task` ENABLE KEYS */;


--
-- Definition of table `scheduler_queue_task_execution`
--

DROP TABLE IF EXISTS `scheduler_queue_task_execution`;
CREATE TABLE `scheduler_queue_task_execution` (
  `id_task_execution` int(11) NOT NULL AUTO_INCREMENT,
  `scheduler_queue_task_id` int(11) NOT NULL,
  `param_special` varchar(100) DEFAULT NULL,
  `user` varchar(16) DEFAULT NULL,
  `group` varchar(25) DEFAULT NULL,
  `status_id` int(11) DEFAULT '1',
  `date_init` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `files` text,
  `result` mediumtext,
  PRIMARY KEY (`id_task_execution`),
  KEY `fk_scheduler_queu_task_execution_scheduler_queu_task_idx` (`scheduler_queue_task_id`),
  KEY `fk_scheduler_queue_task_execution_schedulet_queue_status1_idx` (`status_id`),
  CONSTRAINT `fk_scheduler_queue_task_execution_scheduler_queue_task` FOREIGN KEY (`scheduler_queue_task_id`) REFERENCES `scheduler_queue_task` (`id_task`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_scheduler_queue_task_execution_schedulet_queue_status1` FOREIGN KEY (`status_id`) REFERENCES `scheduler_queue_status` (`id_status`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `scheduler_queue_task_execution`
--

/*!40000 ALTER TABLE `scheduler_queue_task_execution` DISABLE KEYS */;
INSERT INTO `scheduler_queue_task_execution` (`id_task_execution`,`scheduler_queue_task_id`,`param_special`,`user`,`group`,`status_id`,`date_init`,`date_end`,`files`,`result`) VALUES 
 (2,1,'--user=admin','user1','',4,'2024-01-25 19:52:32','2024-01-25 19:52:38','','ok'),
 (3,1,' --user=admin','admin','',4,'2024-01-25 19:52:38','2024-01-25 19:52:43','','ok'),
 (4,2,'','admin','',4,'2024-01-25 19:52:56','2024-01-25 19:53:01','[{\"name\":\"C:\\\\tmp\\\\php\\\\tmp\\\\txtF6CB.tmp\",\"usrName\":\"example.txt\",\"size\":93,\"type\":\"text\\/plain\",\"searchStr\":\"example.txt:sStrEnd\"}]','ok'),
 (5,2,'','admin','',4,'2024-01-25 19:53:01','2024-01-25 19:53:06','[{\"name\":\"C:\\\\tmp\\\\php\\\\tmp\\\\txtB8C.tmp\",\"usrName\":\"example.txt\",\"size\":93,\"type\":\"text\\/plain\",\"searchStr\":\"example.txt:sStrEnd\"}]','ok'),
 (6,1,'','admin',NULL,4,'2024-01-25 20:54:51','2024-01-25 20:54:56',NULL,'ok'),
 (7,2,'','admin',NULL,4,'2024-01-25 20:55:24','2024-01-25 20:55:30','[{\"name\":\"C:\\\\tmp\\\\php\\\\tmp\\\\txt2A69.tmp\",\"usrName\":\"example.txt\",\"size\":93,\"type\":\"text\\/plain\",\"searchStr\":\"example.txt:sStrEnd\"}]','ok'),
 (8,1,'','user1',NULL,4,'2024-01-25 20:54:56','2024-01-25 20:55:02',NULL,'ok'),
 (9,2,'','user1',NULL,4,'2024-01-25 20:55:30','2024-01-25 20:55:35','[{\"name\":\"C:\\\\tmp\\\\php\\\\tmp\\\\txt3F29.tmp\",\"usrName\":\"example.txt\",\"size\":93,\"type\":\"text\\/plain\",\"searchStr\":\"example.txt:sStrEnd\"}]','ok'),
 (10,1,'','admin',NULL,4,'2024-01-25 20:57:09','2024-01-25 20:57:14',NULL,'ok'),
 (11,1,'','admin',NULL,4,'2024-01-25 20:57:14','2024-01-25 20:57:19',NULL,'ok'),
 (12,1,'','admin',NULL,4,'2024-01-25 20:57:19','2024-01-25 20:57:24',NULL,'ok'),
 (14,2,'','admin',NULL,4,'2024-01-25 20:57:44','2024-01-25 20:57:49','[{\"name\":\"C:\\\\tmp\\\\php\\\\tmp\\\\txt4C01.tmp\",\"usrName\":\"example.txt\",\"size\":93,\"type\":\"text\\/plain\",\"searchStr\":\"example.txt:sStrEnd\"}]','ok'),
 (15,2,'','admin',NULL,4,'2024-01-25 20:57:49','2024-01-25 20:57:55','[{\"name\":\"C:\\\\tmp\\\\php\\\\tmp\\\\txt60D1.tmp\",\"usrName\":\"example.txt\",\"size\":93,\"type\":\"text\\/plain\",\"searchStr\":\"example.txt:sStrEnd\"}]','ok'),
 (16,1,'','admin',NULL,4,'2024-01-25 21:02:01','2024-01-25 21:02:07',NULL,'ok'),
 (17,1,'','admin',NULL,4,'2024-01-25 21:02:07','2024-01-25 21:02:12',NULL,'ok'),
 (18,2,'','admin',NULL,4,'2024-01-25 21:03:01','2024-01-25 21:03:07','[{\"name\":\"C:\\\\tmp\\\\php\\\\tmp\\\\txt242D.tmp\",\"usrName\":\"example.txt\",\"size\":93,\"type\":\"text\\/plain\",\"searchStr\":\"example.txt:sStrEnd\"}]','ok'),
 (19,2,'','admin',NULL,4,'2024-01-25 21:03:07','2024-01-25 21:03:12','[{\"name\":\"C:\\\\tmp\\\\php\\\\tmp\\\\txt392C.tmp\",\"usrName\":\"example.txt\",\"size\":93,\"type\":\"text\\/plain\",\"searchStr\":\"example.txt:sStrEnd\"}]','ok');
/*!40000 ALTER TABLE `scheduler_queue_task_execution` ENABLE KEYS */;


--
-- Definition of table `scheduler_queue_uggroups`
--

DROP TABLE IF EXISTS `scheduler_queue_uggroups`;
CREATE TABLE `scheduler_queue_uggroups` (
  `GroupID` int(11) NOT NULL AUTO_INCREMENT,
  `Label` varchar(300) DEFAULT NULL,
  `Provider` varchar(10) DEFAULT '',
  `Comment` mediumtext,
  PRIMARY KEY (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `scheduler_queue_uggroups`
--

/*!40000 ALTER TABLE `scheduler_queue_uggroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `scheduler_queue_uggroups` ENABLE KEYS */;


--
-- Definition of table `scheduler_queue_ugmembers`
--

DROP TABLE IF EXISTS `scheduler_queue_ugmembers`;
CREATE TABLE `scheduler_queue_ugmembers` (
  `UserName` varchar(255) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `Provider` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`UserName`(50),`GroupID`,`Provider`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `scheduler_queue_ugmembers`
--

/*!40000 ALTER TABLE `scheduler_queue_ugmembers` DISABLE KEYS */;
INSERT INTO `scheduler_queue_ugmembers` (`UserName`,`GroupID`,`Provider`) VALUES 
 ('admin',-1,'');
/*!40000 ALTER TABLE `scheduler_queue_ugmembers` ENABLE KEYS */;


--
-- Definition of table `scheduler_queue_ugrights`
--

DROP TABLE IF EXISTS `scheduler_queue_ugrights`;
CREATE TABLE `scheduler_queue_ugrights` (
  `TableName` varchar(255) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `AccessMask` varchar(10) DEFAULT NULL,
  `Page` mediumtext,
  PRIMARY KEY (`TableName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `scheduler_queue_ugrights`
--

/*!40000 ALTER TABLE `scheduler_queue_ugrights` DISABLE KEYS */;
INSERT INTO `scheduler_queue_ugrights` (`TableName`,`GroupID`,`AccessMask`,`Page`) VALUES 
 ('<global>',-1,'ADESPIM',NULL),
 ('scheduler_queue',-1,'ADESPIM',NULL),
 ('scheduler_queue-user',-1,'ADESPIM',NULL),
 ('scheduler_queue_status',-1,'ADESPIM',NULL),
 ('scheduler_queue_task',-2,'S',''),
 ('scheduler_queue_task',-1,'ADESPIM',NULL),
 ('scheduler_queue_task_execution',-2,'S','{\"list\":true,\"search\":true,\"view\":true}'),
 ('scheduler_queue_task_execution',-1,'ADESPIM',NULL);
/*!40000 ALTER TABLE `scheduler_queue_ugrights` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
